using System;
using System.Collections;
using Server;
using Server.Items;

namespace Server.Mobiles
{
	//[CorpseName( "a szavetra corpse" )]
	public class Szavetra : Succubus
	{
		private bool IsMLBoss;
		
      [Constructable]
		public Szavetra() : this ( true )
		{
		}
		
      [Constructable]
		public Szavetra ( bool ismlboss ) : base()
		{
			IsMLBoss = ismlboss;
			Name = "Szavetra";

			SetStr( 727, 741 );
			SetDex( 164, 193 );
			SetInt( 566, 595 );

			SetHits( 8012, 9353 );

			SetDamage( 22, 29 );

			SetDamageType( ResistanceType.Physical, 75 );
			SetDamageType( ResistanceType.Energy, 25 );

			SetResistance( ResistanceType.Physical, 83, 90 );
			SetResistance( ResistanceType.Fire, 72, 75 );
			SetResistance( ResistanceType.Cold, 43, 49 );
			SetResistance( ResistanceType.Poison, 51, 59 );
			SetResistance( ResistanceType.Energy, 50, 60 );

			SetSkill( SkillName.EvalInt, 90.3, 99.8 );
			SetSkill( SkillName.Magery, 130.1, 130.6 );
			SetSkill( SkillName.Meditation, 90.1, 100.0 );
			SetSkill( SkillName.MagicResist, 112.2, 127.2 );
			SetSkill( SkillName.Tactics, 121.5, 132.8 );
			SetSkill( SkillName.Wrestling, 90.2, 96.4 );

			Fame = 19000;
			Karma = -8000;
			VirtualArmor = 50;
			PackItem( new RandomTalisman() );
			PackItem( new Tokens( Utility.RandomMinMax( 10, 25 ) ) );
			   
			if ( IsMLBoss )
			{
				PackItem( new Muculent() );
				if (Utility.RandomDouble() < 0.2)
				  PackItem( Loot.RandomArcanistScroll() );
         }
		}
		
		public override bool BardImmune{ get{ return true; } }
		public override bool Unprovokable{ get{ return true; } }
		public override bool Uncalmable{ get{ return true; } }
		
		public Szavetra( Serial serial ) : base( serial )
		{
		}
		
		public override void OnKilledBy( Mobile mob )
		{
			base.OnKilledBy( mob );

			if ( IsMLBoss && Paragon.CheckArtifactChance( mob, this ) )
			{
				Paragon.GiveMLArtifactTo( mob );
			}
		}
		
		public override void GenerateLoot()
		{
			AddLoot( LootPack.AosSuperBoss );
		}
		
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			
			int version = reader.ReadInt();
		}
	}
}